% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_parameters.R
\name{get_radii}
\alias{get_radii}
\title{Load Radii Values}
\usage{
get_radii()
}
\value{
A data frame containing the radii values.
}
\description{
The 'get_radii' function is responsible for loading the atomic
radii values used for surface-occlusion calculations. The values
it returns are those currently employed in those calculations.
}
\examples{
\donttest{
library(fibos)
fibos_config()
#Loads the radius values that have been configured for code execution.
radii = get_radii()
#Displays the first three lines.
radii |> utils::head(3) |> print()
}

}
\seealso{
\code{\link[=set_radii]{set_radii()}}

\code{\link[=reset_radii]{reset_radii()}}
}
\author{
Carlos Henrique da Silveira (carlos.silveira@unifei.edu.br)

Herson Hebert Mendes Soares (hersonhebert@hotmail.com)

Joao Paulo Roquim Romanelli (joaoromanelli@unifei.edu.br)

Patrick Fleming (Pat.Fleming@jhu.edu)
}
