% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fic.R
\name{plot.fic}
\alias{plot.fic}
\title{Plot focused model comparison statistics: base graphics method}
\usage{
\method{plot}{fic}(
  x,
  ci = TRUE,
  adj = TRUE,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  pch = 19,
  mfrow = NULL,
  ...
)
}
\arguments{
\item{x}{Output from \code{\link{fic}}.}

\item{ci}{Plot interval estimates? (\code{TRUE} or \code{FALSE}).  These are calculated as plus / minus twice the standard error of the submodel focus under the wide model.  These are rough estimates of uncertainty intended to illustrate the bias-variance tradeoff, and exclude any uncertainty associated with the choice between models.}

\item{adj}{The optimal model is the one with the lowest root mean square error (RMSE). If \code{adj=TRUE} the RMSE is based on the adjusted bias estimator.  Otherwise the standard estimator is used.}

\item{xlab}{x-axis label.}

\item{ylab}{y-axis label.}

\item{xlim}{x-axis limits (pair of numbers)}

\item{ylim}{y-axis limits}

\item{pch}{Plot point character, by default 19 (solid circle).}

\item{mfrow}{Vector of two numbers giving the number of rows and number of columns respectively in the plot grid, if there are multiple focuses.}

\item{...}{Other options to pass to \code{\link{plot}}.}
}
\description{
Plot focused model comparison statistics: base graphics method
}
\details{
If the focus estimates are available, then the focus estimates are
plotted against the root MSE.  One plot is made for each covariate
value defining different focuses.  If the wide model estimate is
available, this is illustrated as a solid line on the plot, and if
the narrow model estimate is available, this is shown as a dashed
line.

If the focus estimates are unavailable, then the standard errors
of the focus estimate are plotted against the corresponding bias.
The plot points are shaded with darkness proportional to the RMSE,
with the point of maximum RMSE in black.

The \pkg{ggplot2}-based plot method, \code{\link{ggplot_fic}}, is
slightly nicer.
}
\examples{

## Example from the main vignette, see there for more details

wide.glm <- glm(low ~ lwtkg + age + smoke + ht + ui + smokeage + smokeui,
                data=birthwt, family=binomial)
vals.smoke <-    c(1, 58.24, 22.95, 1, 0, 0, 22.95, 0)
vals.nonsmoke <- c(1, 59.50, 23.43, 0, 0, 0, 0, 0)
X <- rbind("Smokers" = vals.smoke, "Non-smokers" = vals.nonsmoke)
inds0 <- c(1,1,0,0,0,0,0,0)
combs <- all_inds(wide.glm, inds0)
ficres <- fic(wide = wide.glm, inds = combs, inds0 = inds0,
              focus = prob_logistic, X = X)
plot(ficres)

}
\seealso{
\code{\link{ggplot_fic}}, \code{\link{summary.fic}}
}
