% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score-forest_imp.R
\docType{data}
\name{score_imp_rf}
\alias{score_imp_rf}
\alias{score_imp_rf_conditional}
\alias{score_imp_rf_oblique}
\title{Scoring via random forests}
\format{
An object of class \code{filtro::class_score_imp_rf} (inherits from \code{filtro::class_score}, \code{S7_object}) of length 1.

An object of class \code{filtro::class_score_imp_rf} (inherits from \code{filtro::class_score}, \code{S7_object}) of length 1.

An object of class \code{filtro::class_score_imp_rf} (inherits from \code{filtro::class_score}, \code{S7_object}) of length 1.
}
\usage{
score_imp_rf

score_imp_rf_conditional

score_imp_rf_oblique
}
\value{
An S7 object. The primary property of interest is in \code{results}. This
is a data frame of results that is populated by the \code{fit()} method and has
columns:
\itemize{
\item \code{name}: The name of the score (e.g., \code{imp_rf}).
\item \code{score}: The estimates for each predictor.
\item \code{outcome}: The name of the outcome column.
\item \code{predictor}: The names of the predictor inputs.
}

These data are accessed using \code{object@results} (see examples below).
}
\description{
Three different random forest models can be used to measure predictor importance.
}
\details{
These objects are used when either:
\itemize{
\item The predictors are numeric and the outcome is a factor/category, or
\item The predictors are factors and the outcome is numeric.
}

In either case, a random forest, conditional random forest, or oblique random forest
(via \code{\link[ranger:ranger]{ranger::ranger()}}, \code{\link[partykit:cforest]{partykit::cforest()}}, or \code{\link[aorsf:orsf]{aorsf::orsf()}}) is created with
the proper variable roles, and the feature importance scores are computed. Larger
values are associated with more important predictors.

When a predictor's importance score is 0, \code{\link[partykit:cforest]{partykit::cforest()}} may omit its
name from the results. In cases like these, a score of 0 is assigned to the
missing predictors.
\subsection{Estimating the scores}{

In \pkg{filtro}, the \verb{score_*} objects define a scoring method (e.g., data
input requirements, package dependencies, etc). To compute the scores for
a specific data set, the \code{fit()} method is used. The main arguments for
these functions are:

\describe{
\item{\code{object}}{A score class object (e.g., \code{score_imp_rf}).}
\item{\code{formula}}{A standard R formula with a single outcome on the right-hand side and one or more predictors (or \code{.}) on the left-hand side. The data are processed via \code{\link[stats:model.frame]{stats::model.frame()}}}
\item{\code{data}}{A data frame containing the relevant columns defined by the formula.}
\item{\code{...}}{Further arguments passed to or from other methods.}
\item{\code{case_weights}}{A quantitative vector of case weights that is the same length as the number of rows in \code{data}. The default of \code{NULL} indicates that there are no case weights.}
}

Missing values are removed by case-wise deletion.
}

In cases where the underlying computations fail, the scoring proceeds
silently, and a missing value is given for the score.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(dplyr)

# Random forests for classification task

cells_subset <- modeldata::cells |>
  # Use a small example for efficiency
  dplyr::select(
    class,
    angle_ch_1,
    area_ch_1,
    avg_inten_ch_1,
    avg_inten_ch_2,
    avg_inten_ch_3
  ) |>
  slice(1:50)

# Random forest
set.seed(42)
cells_imp_rf_res <- score_imp_rf |>
  fit(class ~ ., data = cells_subset)
cells_imp_rf_res@results

# Conditional random forest
cells_imp_rf_conditional_res <- score_imp_rf_conditional |>
  fit(class ~ ., data = cells_subset, trees = 10)
cells_imp_rf_conditional_res@results

# Oblique random forest
cells_imp_rf_oblique_res <- score_imp_rf_oblique |>
  fit(class ~ ., data = cells_subset)
cells_imp_rf_oblique_res@results

# ----------------------------------------------------------------------------

# Random forests for regression task

ames_subset <- modeldata::ames |>
  # Use a small example for efficiency
  dplyr::select(
    Sale_Price,
    MS_SubClass,
    MS_Zoning,
    Lot_Frontage,
    Lot_Area,
    Street
  ) |>
  slice(1:50)
ames_subset <- ames_subset |>
  dplyr::mutate(Sale_Price = log10(Sale_Price))

set.seed(42)
ames_imp_rf_regression_task_res <-
  score_imp_rf |>
  fit(Sale_Price ~ ., data = ames_subset)
ames_imp_rf_regression_task_res@results
\dontshow{\}) # examplesIf}
}
\seealso{
Other class score metrics: 
\code{\link{score_aov_pval}},
\code{\link{score_cor_pearson}},
\code{\link{score_info_gain}},
\code{\link{score_roc_auc}},
\code{\link{score_xtab_pval_chisq}}
}
\concept{class score metrics}
\keyword{datasets}
