% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{get_data}
\alias{get_data}
\title{Main logic forming the API call.}
\usage{
get_data(
  api_number = NA,
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA,
  page_size = 20000
)
}
\arguments{
\item{api_number}{Integer related to the Fingrid Open Data API}

\item{start_time_utc}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time_utc}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en.}

\item{page_size}{Integer how many observations are in a single page.
Defaults to API maximum 20000.}
}
\value{
A data frame object that contains wanted open data.
}
\description{
Main logic forming the API call. API key
can be provided as function parameter or environment
variable (in .Renviron as FINGRID_OPENDATA_API_KEY).
Function parameter has precedence in case both are provided.
For API spec see https://data.fingrid.fi/en/pages/api.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"
end = "2024-06-03T00:00:00.000Z"
key = "MY_SUPER_SECRET"
df <- get_data(api_number = 124,  # electricity consumption for Finland
               start_time_utc = start,
               end_time_utc = end,
               user_key = key,
               page_size = 20000)
summary(df)
}
}
