% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_vocabulary_concepts.R
\name{search_vocabulary_concepts}
\alias{search_vocabulary_concepts}
\title{Search for concepts and collections in a specific vocabulary from the Finto Skosmos API}
\usage{
search_vocabulary_concepts(
  vocid,
  query,
  lang = NULL,
  type = NULL,
  maxhits = NULL,
  offset = NULL
)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{query}{The search term, e.g., "cat*".}

\item{lang}{The language of labels to match, e.g., "en" or "fi". Optional.}

\item{type}{Limit search to concepts of a given type, e.g., "skos:Concept". Optional.}

\item{maxhits}{Maximum number of results to return. Optional.}

\item{offset}{Offset where to start in the result set, useful for paging. Optional.}
}
\value{
A tibble containing the search results with fields such as uri, type, prefLabel, and altLabel.
}
\description{
Search for concepts and collections in a specific vocabulary from the Finto Skosmos API
}
\examples{
search_results <- search_vocabulary_concepts(vocid = "yso", query = "cat", lang = "en")
print(search_results)
}
