% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SecurityHeaders_helpers.R
\name{csp}
\alias{csp}
\title{Construct settings for the \code{Content-Security-Policy} header}
\usage{
csp(
  default_src = NULL,
  script_src = NULL,
  script_src_elem = NULL,
  script_src_attr = NULL,
  style_src = NULL,
  style_src_elem = NULL,
  style_src_attr = NULL,
  img_src = NULL,
  font_src = NULL,
  media_src = NULL,
  object_src = NULL,
  child_src = NULL,
  frame_src = NULL,
  worker_src = NULL,
  connect_src = NULL,
  fenced_frame_src = NULL,
  manifest_src = NULL,
  prefetch_src = NULL,
  base_uri = NULL,
  sandbox = FALSE,
  form_action = NULL,
  frame_ancestors = NULL,
  report_to = NULL,
  require_trusted_types_for = FALSE,
  trusted_types = NULL,
  upgrade_insecure_requests = FALSE
)
}
\arguments{
\item{default_src}{Fallback for all other \verb{*_src} values}

\item{script_src}{Fallback for \verb{script_src_*} values}

\item{script_src_elem}{Valid sources for \verb{<script>} elements}

\item{script_src_attr}{Valid sources for inline event handlers}

\item{style_src}{Fallback for \verb{style_src_*} values}

\item{style_src_elem}{Valid sources for \verb{<style>} elements}

\item{style_src_attr}{Valid sources for inline styling of elements}

\item{img_src}{Valid sources for images and favicons}

\item{font_src}{Valid sources for fonts loaded with \verb{@font-face}}

\item{media_src}{Valid sources for \verb{<audio>}, \verb{<video>}, and \verb{<track>} elements}

\item{object_src}{Valid sources for \verb{<object>} and \verb{<embed>} elements}

\item{child_src}{Fallback for \code{frame_src} and \code{worker_src}}

\item{frame_src}{Valid sources for \verb{<frame>} and \verb{<iframe>} elements}

\item{worker_src}{Valid sources for \code{Worker}, \code{SharedWorker}, and
\code{ServiceWorker} scripts}

\item{connect_src}{Valid sources for URLs loaded from within scripts}

\item{fenced_frame_src}{Valid sources for \verb{<fencedframe>} elements}

\item{manifest_src}{Valid sources for application manifest files}

\item{prefetch_src}{Valid sources to be prefetched and prerendered}

\item{base_uri}{Valid sources that can be put in a \verb{<base>} element}

\item{sandbox}{Logical. Enable sandboxing of the requested document/ressource}

\item{form_action}{Valid URLs to be targeted by form submissions}

\item{frame_ancestors}{Valid parents that may embed this document in an
\verb{<frame>}, \verb{<iframe>}, \verb{<object>}, or \verb{<embed>} element.}

\item{report_to}{A URL to report violations to. Setting this will also add
a \code{report-uri} directive along with a \code{Reporting-Endpoints} header for
maximum compitability.}

\item{require_trusted_types_for}{Logical. Enforces \href{https://developer.mozilla.org/en-US/docs/Web/API/Trusted_Types_API}{Trusted Types}}

\item{trusted_types}{Specifies an allow list of \href{https://developer.mozilla.org/en-US/docs/Web/API/Trusted_Types_API}{Trusted Types}}

\item{upgrade_insecure_requests}{Logical. Automatically treat all HTTP urls in the
document as if they were HTTPS}
}
\value{
A bare list with the input arguments
}
\description{
This helper function exists mainly to document the possible values and
prevent misspelled directives. It returns a bare list. See
\href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/Content-Security-Policy}{the header reference}
and \href{https://developer.mozilla.org/docs/Web/Security/Practical_implementation_guides/CSP}{the CSP section of the MDN security guide}
for more information on the header
}
\examples{
# Default setting
csp(
  default_src = "self",
  script_src = "self",
  script_src_attr = "none",
  style_src = c("self", "https:", "unsafe-inline"),
  img_src = c("self", "data:"),
  font_src = c("self", "https:", "data:"),
  object_src = "none",
  base_uri = "self",
  form_action = "self",
  frame_ancestors = "self",
  upgrade_insecure_requests = TRUE
)

}
