% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{expandUnknownParents}
\alias{expandUnknownParents}
\title{Generate markers with all combinations of parental scores}
\usage{
expandUnknownParents(scores, sep="@",
polysomic=TRUE, disomic=FALSE, mixed=FALSE,
ploidy, ploidy2, scorefile)
}
\arguments{
\item{scores}{a data frame as returned by writeDosagefile, or the combscores
item in the return value of compareProbes or removeRedundant}

\item{sep}{a short string (one or more characters, default "@")
to separate the original marker name from the consecutive letters
(a, b, c etc) that identify the different versions of the marker. Markers
that already have parental scores are not modified}

\item{polysomic}{TRUE or FALSE; should be the same as used by checkF1}

\item{disomic}{TRUE or FALSE; should be the same as used by checkF1}

\item{mixed}{TRUE or FALSE; should be the same as used by checkF1}

\item{ploidy}{the ploidy of parent 1 (must be even, 2 (diploid) or larger),
and the same as used by checkF1}

\item{ploidy2}{the ploidy of parent 2. If omitted it is assumed to be equal
to ploidy. Should be the same as used by checkF1}

\item{scorefile}{a filename to which the result is written;
if NA no file is written}
}
\value{
A data frame with the same format and contents as parameter scores,
with each marker where parental scores were missing expanded to
multiple rows, one per parental dosage combination
}
\description{
For markers where the segregation type in the F1 is known but the
parental consensus scores are missing, this function generates multiple
versions of the marker, each with a different combination of parental scores
matching the segregation and a different suffix to the marker name.
}
