% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intraday.R
\name{get_heart_rate_intraday}
\alias{get_heart_rate_intraday}
\title{Get intraday heart time series}
\usage{
get_heart_rate_intraday(
  date = lubridate::today(),
  detail_level = c("1sec", "1min", "5min", "15min"),
  start_time = NULL,
  end_time = NULL
)
}
\arguments{
\item{date}{A date to get data for}

\item{detail_level}{The detail level. One of \code{"1sec"}, \code{"1min"}, \code{"5min"}, or \code{"15min"}}

\item{start_time}{The start time of the time window. Default: \code{NULL} gets the whole day}

\item{end_time}{The end time of the time window. Default: \code{NULL} gets the whole day}
}
\description{
See the \href{https://dev.fitbit.com/reference/web-api/heart-rate/#get-heart-rate-time-series}{API documentation} for
more detailed explanations of parameters and more usage information and examples.
}
\examples{
\dontrun{
date <- lubridate::today()

## get minute by minute data
get_heart_rate_intraday(detail_level = "15min")

## get more granular data
get_heart_rate_intraday(detail_level = "1min")
}
}
\seealso{
Other intraday: 
\code{\link{get_active_zone_minutes_intraday}()},
\code{\link{get_calories_intraday}()},
\code{\link{get_distance_intraday}()},
\code{\link{get_elevation_intraday}()},
\code{\link{get_floors_intraday}()},
\code{\link{get_steps_intraday}()}
}
\concept{intraday}
