% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_transforming.R
\name{series_mutate}
\alias{series_mutate}
\title{Transform variables in a data frame}
\usage{
series_mutate(
  data,
  x,
  y,
  grp,
  metadata,
  max_as_last = FALSE,
  check_negative = FALSE,
  add_zero = FALSE,
  interval = NULL
)
}
\arguments{
\item{data}{A \code{data.frame} containing the input data for analysis.}

\item{x}{The name of the column in \code{data} representing the independent variable (x points).}

\item{y}{The name of the column(s) in \code{data} containing variables to transform.}

\item{grp}{Column(s) in \code{data} used as grouping variable(s). Defaults to \code{NULL} (optional).}

\item{metadata}{Names of columns to retain in the output. Defaults to \code{NULL} (optional).}

\item{max_as_last}{Logical. If \code{TRUE}, appends the maximum value after reaching the maximum. Default is \code{FALSE}.}

\item{check_negative}{Logical. If \code{TRUE}, converts negative values in the data to zero. Default is \code{FALSE}.}

\item{add_zero}{Logical. If \code{TRUE}, adds a zero value to the series at the start. Default is \code{FALSE}.}

\item{interval}{A numeric vector of length 2 (start and end) specifying the range to filter the data. Defaults to \code{NULL}.}
}
\value{
A transformed \code{data.frame} with the specified modifications applied.
}
\description{
This function performs transformations on specified columns of a data frame,
including truncating maximum values, handling negative values, and adding a zero
to the series. It allows for grouping and supports retaining metadata in the output.
}
\examples{
data(dt_potato)
new_data <- series_mutate(
  data = dt_potato,
  x = DAP,
  y = GLI,
  grp = gid,
  max_as_last = TRUE,
  check_negative = TRUE
)
}
