% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzification.R
\name{fuzzify_crisp_matrix}
\alias{fuzzify_crisp_matrix}
\title{Fuzzify a matrix of crisp values}
\usage{
fuzzify_crisp_matrix(crisp_matrix, spread = 1)
}
\arguments{
\item{crisp_matrix}{Numeric matrix to be fuzzified.}

\item{spread}{Numeric. The spread for fuzzification (default is 1).}
}
\value{
A list of lists representing rows of triangular fuzzy numbers.
}
\description{
Converts a numeric matrix into a list of triangular fuzzy numbers.
}
\examples{
set.seed(123)
matrix <- matrix(runif(9, 5, 15), nrow = 3, ncol = 3)
fuzzify_crisp_matrix(matrix, spread = 1.5)
}
