% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta_estimation.R
\name{th_est_ml}
\alias{th_est_ml}
\alias{th_est_eap}
\title{Latent Trait Estimation}
\usage{
th_est_ml(dat, bmat, maxncat = 2, cvec = NULL, dvec = NULL, lb = -4, ub = 4)

th_est_eap(
  dat,
  bmat,
  maxncat = 2,
  cvec = NULL,
  dvec = NULL,
  int = int_mat(npts = 33)
)
}
\arguments{
\item{dat}{Data matrix of binary item responses with one column for each
item. Alternatively, a vector of binary item responses for one person.}

\item{bmat}{Matrix of FMP item parameters, one row for each item.}

\item{maxncat}{Maximum number of response categories (the first maxncat - 1
columns of bmat are intercepts)}

\item{cvec}{Vector of lower asymptote parameters, one element for each item.}

\item{dvec}{Vector of upper asymptote parameters, one element for each item.}

\item{lb}{Lower bound at which to truncate ML estimates.}

\item{ub}{Upper bound at which to truncate ML estimates.}

\item{int}{Matrix with two columns used for numerical integration in EAP.
Column 1 contains the x coordinates and Column 2 contains the densities.}
}
\value{
Matrix with two columns: est and either sem or psd
   \item{est}{Latent trait estimate}
   \item{sem}{Standard error of measurement (mle estimates)}
   \item{psd}{Posterior standard deviation (eap estimates)}
}
\description{
Compute latent trait estimates using either maximum likelihood (ML) or
expected a posteriori (EAP) trait estimation.
}
\examples{

set.seed(3453)
bmat <- sim_bmat(n_items = 20, k = 0)$bmat

theta <- rnorm(10)
dat <- sim_data(bmat = bmat, theta = theta)

## mle estimates
mles <- th_est_ml(dat = dat, bmat = bmat)

## eap estimates
eaps <- th_est_eap(dat = dat, bmat = bmat)

cor(mles[,1], eaps[,1])
# 0.9967317

}
