% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-clusters.R
\name{get_clusters}
\alias{get_clusters}
\title{Identify clusters of cells that meet the criteria}
\usage{
get_clusters(
  xden,
  minden,
  xden2 = NULL,
  minden2 = NULL,
  xsiz = NULL,
  minsiz,
  directions
)
}
\arguments{
\item{xden}{SpatRaster. Grid for density criterium 1}

\item{minden}{numeric. Minimum density threshold 1}

\item{xden2}{SpatRaster. Grid for density criterium 2}

\item{minden2}{numeric. Minimum density threshold 2}

\item{xsiz}{SpatRaster. Grid for the size criterium. If \code{NULL}, then \code{xden} is employed for the size criterium.}

\item{minsiz}{numeric. Minimum size threshold}

\item{directions}{integer. Which cells are considered adjacent:  \code{4} for rooks case (horizontal and vertical neighbours) or \code{8} for queens case (horizontal, vertical and diagonal neighbours)}
}
\value{
SpatRaster with cluster of cells. The value of the cells represent the id of the clusters.
}
\description{
Identify clusters of cells that meet the minimum density criterium/citeria, the minimum size criterium and the contiguity criterium.

The function can be executed with one density criterium, or with two density criteria:
\itemize{
\item \strong{With one density criterium:} Cells are selected if their value is above or equal to the density threshold (\code{xden >= minden}). Selected cells are afterwards grouped together based on the contiguity rule. Groups of cells are valid clusters if they also meet the total size criterium (sum of \code{xsiz} per group above or equal to\code{minsiz}).
\item \strong{With two density criteria:} Cells are selected if their value is above or equal to one of two density thresholds (\code{xden >= minden}, or \code{xden2 >= minden2}). Selected cells are afterwards grouped together based on the contiguity rule. Groups of cells are valid clusters if they also meet the total size criterium (sum of \code{xsiz} per group above or equal to\code{minsiz}).
}
}
\examples{
# load data
grid_data_belgium <- flexurba::DoU_load_grid_data_belgium()

# get clusters of cells (4-cell connectivity) with at least 1500 inhabitants
# per km² of permanent land and a minimum total population of 50 000
# inhabitants:
terra::plot(get_clusters(
  xden = grid_data_belgium$pop_per_land,
  minden = 1500,
  xsiz = grid_data_belgium$pop,
  minsiz = 50000,
  directions = 4
))

# get clusters of cells (4-cell connectivity) with at least 1500 inhabitants
# per km² of permanent land or at least 20\% built-up area per permanent
# land, and a minimum total population of 50 000 inhabitants:
terra::plot(get_clusters(
  xden = grid_data_belgium$pop_per_land,
  minden = 1500,
  xden2 = grid_data_belgium$built_per_land,
  minden2 = 0.2,
  xsiz = grid_data_belgium$pop,
  minsiz = 50000,
  directions = 4
))

# get clusters of cells (8-cell connectivity) with at least 300 inhabitants
# per km² of permanent land, and a minimum total population of 5000
# inhabitants:
terra::plot(get_clusters(
  xden = grid_data_belgium$pop_per_land,
  minden = 300,
  xsiz = grid_data_belgium$pop,
  minsiz = 5000,
  directions = 8
))
}
