% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{plot_flights}
\alias{plot_flights}
\title{The main function to plot flight paths}
\usage{
plot_flights(
  trips,
  crop = TRUE,
  land_color = "#f6e8c3",
  water_color = "aliceblue",
  dom_color = "#3288bd",
  int_color = "#d53e4f",
  alpha = 0.5,
  times_as_thickness = TRUE
)
}
\arguments{
\item{trips}{A two-column dataframe - The start and end airports of flights. The first column should be the start airports, and the second column the end airports. The airport value should be IATA airport code. The column names can be any valid names.}

\item{crop}{A logical value or a string - Whether the map should be cropped or not and by which preset the map is cropped. If \code{FALSE}, the whole world map is plotted; if \code{TRUE}, the map will be cropped based on the airport coordinates. It also accepts certain strings as presets: \cr
\code{"NA"}: North America. \cr
\code{"48States"}: The contiguous United States. \cr
The default value is \code{TRUE}.}

\item{land_color}{A string - the color used for land. Default value is \code{"#f6e8c3"}.}

\item{water_color}{A string - the color used for earth. Default value is \code{"aliceblue"}.}

\item{dom_color}{A string - the color used for domestic flights. Default value is \code{"#3288bd"}.}

\item{int_color}{A string - the color used for international flights. Default value is \code{"#d53e4f"}.}

\item{alpha}{A double number - 0 to 1. The transparency (alpha) of flight paths. Default value is \code{0.5}.}

\item{times_as_thickness}{A logical value - whether the times of flights are used as aestheic mappings for the thickness of flight paths. Default value is \code{TRUE}.}
}
\value{
A plot
}
\description{
The \code{plot_flights} function use 'ggplot2' to plot flight paths on a world map. The flight path follow the great circle of the Earth, which is computed by 'geosphere'. The function also provides extended functionalities including coloring and cropping. \cr
Since 'ggplot2' is used, additional plotting parameters can be easily added to the result.
}
\examples{
plot_flights(sample_trips[1:20,])

}
