% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seas2ann.R
\name{seas2ann}
\alias{seas2ann}
\title{Annual maxima from seasonal maxima}
\usage{
seas2ann(x1, x2, na.rm = TRUE)
}
\arguments{
\item{x1}{vector or matrix of observations from season 1 (rows: observations, columns: stations).}

\item{x2}{vector or matrix of observations from season 2 (rows: observations, columns: stations).}

\item{na.rm}{logical. \code{TRUE}: the annual maximum will be calculated even if one
observation of the two seasons is a missing value, e.g. winter maximum is 58 and summer
maximum is \code{NA} the annual maximum is 58. If both observations are NA, the annual maximum is set to \code{NA}, too.
\code{FALSE}: the annual maximum will be set to \code{NA} if one
observation of the two seasons is a missing value, e.g. winter maximum is 58 and summer maximum
is \code{NA} the annual maximum is \code{NA}.}
}
\value{
Matrix of annual observations (rows: observations, columns: stations).
}
\description{
Calculates annual maxima from seasonal maxima of two seasons.
}
\examples{
set.seed(28379)
x1 <- matrix(round(rnorm(8, 20, 25)), ncol=2)
x1[2] <- NA
x2 <- matrix(round(rnorm(8, 20, 25)), ncol=2)
x2[c(2,5,6)] <- NA
x1
x2
seas2ann(x1,x2,TRUE)
seas2ann(x1,x2,FALSE)
}

