% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_survey_data.R
\name{bind_survey_data}
\alias{bind_survey_data}
\title{Bind survey data}
\usage{
bind_survey_data(
  .,
  questions_data = NULL,
  order_data = NULL,
  labels_data = NULL,
  colors_data = NULL,
  places_data = NULL,
  answer_groups_data = NULL,
  questions_categorical = NULL,
  questions_continuous = NULL,
  questions_geo = NULL,
  questions_label = NULL,
  questions_column_filter = NULL,
  questions_id = NULL,
  questions_metadata = NULL,
  order_categories = NULL,
  labels_label = NULL,
  labels_replacement = NULL,
  colors_question = NULL,
  colors_answer = NULL,
  colors_color = NULL,
  places_latitude = NULL,
  places_longitude = NULL,
  places_names = NULL,
  answer_groups_group = NULL,
  answer_groups_question = NULL,
  answer_groups_display_as = NULL,
  answer_groups_affirmative_answers = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{questions_data}{Questions data. The main data sheet. Each row in this table will become a dot in the graphic..}

\item{order_data}{Order data. Groups by default appear in size or alphabetical order. You can override these with the "Group order" sheet..}

\item{labels_data}{Labels data. Allows you to change how any phrase in the main data sheet is displayed in the graphic. Useful for shortening long questions, translating, etc..}

\item{colors_data}{Colors data. Use this extra table if you want to specify specific colors in the context of specific questions. E.g. to make a red to green scale from "strongly diagree" to "strongly agree"..}

\item{places_data}{Places data. A table of places found in the geographic columns of the main data sheet, each with latitude and longitude to plot it on the map.}

\item{answer_groups_data}{Answer groups data. Grouped questions, in the form "Which of the following apply?", are made by combining mutiple yes/no columns in the main data sheet..}

\item{questions_categorical}{Categorical columns. Each of these columns appears in the Group by, Shade by and Compare dropdowns. Flourish type hint: columns}

\item{questions_continuous}{Continuous columns. Must contain numbers. Each of these columns appears in the Size by dropdown. Flourish type hint: columns}

\item{questions_geo}{Geographic columns. Must contain place names matching those specified in the Places sheet. Set to blank to disable the map mode. Flourish type hint: columns}

\item{questions_label}{Label. A column containing text (e.g. names or emoji) to write on the dots. Not recommended for datasets with more than a few hundred dots. Flourish type hint: column}

\item{questions_column_filter}{Slider or menu. Add a time slider or menu to filter the data based on the contents of a single column. Flourish type hint: column}

\item{questions_id}{Unique name/ID. Specify to allow animations between multiple occurrences of the same person or thing e.g. when using a time slider. Flourish type hint: column}

\item{questions_metadata}{Info for popups. One or more columns of information (text, image URLs, embedded charts etc) to include in popups and panelsFlourish type hint: columns}

\item{order_categories}{Order of answers. Use one column for each question or metric. Put the column header from the main data sheet at the top (e.g. "Do you agree?"), followed by the answers in the order you want (e.g. "disagree", "neutral", "agree"). Flourish type hint: columns}

\item{labels_label}{Label. A column containing phrases from the main data sheet. Flourish type hint: column}

\item{labels_replacement}{Replacement. A column containing the phrase to display. Flourish type hint: column}

\item{colors_question}{Question. The column header (e.g. a survey question) exactly as it appears in the main data sheet. Flourish type hint: column}

\item{colors_answer}{Answer. Use one column for each question or metric. Put the column header from the main datasheet at the top (e.g. "Do you agree?"), followed by the answers in the order you want (e.g. "disagree", "neutral", "agree"). Flourish type hint: column}

\item{colors_color}{Color. A color name (e.g. orange, red) or code (e.g. #ff3300, #ff0000). Flourish type hint: column}

\item{places_latitude}{Latitude. A column of latitude values. Flourish type hint: column}

\item{places_longitude}{Longitude. A column of longitude values. Flourish type hint: column}

\item{places_names}{Names. One or more columns of place names matching those in the main data sheet. Flourish type hint: columns}

\item{answer_groups_group}{Group name. This column will contain the name of the grouped question Flourish type hint: column}

\item{answer_groups_question}{Question. A question that matches exactly one of the questions in the datasheet. Flourish type hint: column}

\item{answer_groups_display_as}{Display answer as. This will be the new text for the question. Flourish type hint: column}

\item{answer_groups_affirmative_answers}{Answers to include. The respondent is included in the group if their answer to the question is one of the answers listed in these columns. Flourish type hint: columns}
}
\value{
A Flourish chart
}
\description{
Bind survey data
}
\examples{
try(
  flourish(chart_type = "survey", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_survey_data(gapminder)
)
}
