% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor.R
\name{fm_tensor}
\alias{fm_tensor}
\title{Make a tensor product function space}
\usage{
fm_tensor(x, ...)
}
\arguments{
\item{x}{list of function space objects, such as \code{\link[=fm_mesh_2d]{fm_mesh_2d()}}.}

\item{...}{Currently unused}
}
\value{
A \code{fm_tensor} or \code{fm_tensor_list} object. Elements of \code{fm_tensor}:
\describe{
\item{fun_spaces}{\code{fm_list} of function space objects}
\item{manifold}{character; manifold type summary. Regular subset of Rd "Rd",
if all function spaces have type "R",
torus connected "Td" if all function spaces have type "S", and otherwise "Md"
In all cases, \code{d} is the sum of the manifold dimensions of the function
spaces.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Tensor product function spaces. The interface and object storage model
is experimental and may change.
}
\examples{
m <- fm_tensor(list(
  space = fmexample$mesh,
  time = fm_mesh_1d(1:5)
))
m2 <- fm_as_tensor(m)
m3 <- fm_as_tensor_list(list(m, m))
c(fm_dof(m$fun_spaces$space) * fm_dof(m$fun_spaces$time), fm_dof(m))
str(fm_evaluator(m, loc = list(space = cbind(0, 0), time = 2.5)))
str(fm_basis(m, loc = list(space = cbind(0, 0), time = 2.5)))
str(fm_fem(m))
}
\seealso{
Other object creation and conversion: 
\code{\link{fm_as_collect}()},
\code{\link{fm_as_fm}()},
\code{\link{fm_as_lattice_2d}()},
\code{\link{fm_as_lattice_Nd}()},
\code{\link{fm_as_mesh_1d}()},
\code{\link{fm_as_mesh_2d}()},
\code{\link{fm_as_mesh_3d}()},
\code{\link{fm_as_segm}()},
\code{\link{fm_as_sfc}()},
\code{\link{fm_as_tensor}()},
\code{\link{fm_collect}()},
\code{\link{fm_lattice_2d}()},
\code{\link{fm_lattice_Nd}()},
\code{\link{fm_mesh_1d}()},
\code{\link{fm_mesh_2d}()},
\code{\link{fm_segm}()},
\code{\link{fm_simplify}()}
}
\concept{object creation and conversion}
