% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.fmx.R
\name{as.fmx.Skew.normal}
\alias{as.fmx.Skew.normal}
\title{Convert \code{Skew.normal} Object to \linkS4class{fmx}}
\usage{
\method{as.fmx}{Skew.normal}(x, data, ...)
}
\arguments{
\item{x}{\code{'Skew.normal'} object,
returned from \link[mixsmsn]{smsn.mix} with parameter
\code{family = 'Skew.normal'}.}

\item{data}{\link[base]{numeric} \link[base]{vector}}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \code{\link[=as.fmx.Skew.normal]{as.fmx.Skew.normal()}} returns an \linkS4class{fmx} object.
}
\description{
To convert \code{Skew.normal} object (from package \CRANpkg{mixsmsn})
to \linkS4class{fmx} class.
}
\note{
\link[mixsmsn]{smsn.mix} does not offer a parameter to keep the input data, as of 2021-10-06.
}
\examples{
library(mixsmsn)
# ?smsn.mix
arg1 = c(mu = 5, sigma2 = 9, lambda = 5, nu = 5)
arg2 = c(mu = 20, sigma2 = 16, lambda = -3, nu = 5)
arg3 = c(mu = 35, sigma2 = 9, lambda = -6, nu = 5)
set.seed(120); x = rmix(n = 1e3L, p=c(.5, .2, .3), family = 'Skew.t', 
  arg = list(unname(arg1), unname(arg2), unname(arg3)))

# Skew Normal
class(m1 <- smsn.mix(x, nu = 3, g = 3, family = 'Skew.normal', calc.im = FALSE))
mix.hist(y = x, model = m1)
m1a = as.fmx(m1, data = x)
(l1a = logLik(m1a))
hist(x, freq = FALSE)
curve(dfmx(x, dist = m1a), xlim = range(x), add = TRUE)

}
