% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matrix_apply}
\alias{matrix_apply}
\alias{mat_apply}
\alias{row_apply}
\alias{col_apply}
\title{Matrix Apply Functions}
\usage{
mat_apply(X, f)

row_apply(X, f)

col_apply(X, f)
}
\arguments{
\item{X}{A matrix}

\item{f}{The function to apply.}
}
\value{
\code{mat_apply} returns a matrix. \code{row_apply} and \code{col_apply} return a vector.
See section "Apply" of the package vignette for details.
}
\description{
Matrix Apply Functions
}
\details{
The \code{mat_apply}, \code{row_apply}, and \code{col_apply} C++ functions are intended to
operate like the following calls in R, respectively.

\if{html}{\out{<div class="sourceCode">}}\preformatted{apply(x, c(1,2), f)
apply(x, 1, f)
apply(x, 2, f)
}\if{html}{\out{</div>}}

The R functions exposed here are specific to numeric-valued matrices, but
the underlying C++ functions are intended to work with any type of Rcpp
Matrix.
}
\examples{
X = matrix(1:12, nrow = 4, ncol = 3)
mat_apply(X, f = function(x) { x^(1/3) })
row_apply(X, f = function(x) { sum(x^2) })
col_apply(X, f = function(x) { sum(x^2) })

}
