% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\docType{data}
\name{fui_el}
\alias{fui_el}
\title{Create Fomantic UI Elements}
\format{
An object of class \code{list} of length 41.
}
\usage{
fui_el
}
\description{
Create an R object that represents a Fomantic UI Element e.g. segment or container. The contents have remained
as minimal as possible to enable the greatest possible flexibility.
}
\details{
Most of the elements work just like a standard HTML tag with some pre-defined classes, however there are a few
elements which require a value, and so have an extra argument attached:

\describe{
\item{\code{emoji}}{FUI Element: \code{emoji} - The string of the emoji name}
\item{\code{country}}{FUI Element: \code{flag} - Either the country name or 2 character ISO code}
\item{\code{icon}}{FUI Element: \code{icon} - The space separated name of the Font Awesome icon}
\item{\code{html_tag}}{FUI Elements: \code{header, list, item} - For certain elements, multiple HTML tags can be used.
The default is set to \code{div}, but can be set to any valid HTML tag.}
}
}
\examples{
# List
fui_el$list(
  fui_el$item("Item 1"),
  fui_el$item("Item 2"),
  fui_el$item("Item 3")
)

# Pink Segment
fui_el$segment(
  class = "pink"
)

# Grid
fui_el$grid(
  fui_el$row(
    class = "two column",
    fui_el$column(),
    fui_el$column()
  )
)

# Flag
fui_el$flag("fr")

# Icon
fui_el$icon("exclamation triangle")

}
\seealso{
\url{https://fomantic-ui.com} for styling Fomantic UI elements, \code{\link[htmltools]{builder}}
}
\keyword{datasets}
