% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_record_by_season.R
\name{plot_record_by_season}
\alias{plot_record_by_season}
\title{Plot sample records by season}
\usage{
plot_record_by_season(data)
}
\arguments{
\item{data}{a \code{tibble} or a \code{data.frame}, i.e. a FORCIS dataset.}
}
\value{
A \code{ggplot} object.
}
\description{
This function produces a barplot of FORCIS sample records by season.
}
\examples{
# Import example dataset ----
file_name <- system.file(file.path("extdata", "FORCIS_net_sample.csv"),
                         package = "forcis")

net_data <- read.csv(file_name)

# Plot data by year (example dataset) ----
plot_record_by_season(net_data)
}
