% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GR4J_funcs.R
\name{GR4J_wrapper}
\alias{GR4J_wrapper}
\title{System model wrapper GR4J}
\usage{
GR4J_wrapper(data, systemArgs, metrics)
}
\arguments{
\item{data}{list; contains daily precipitation and PET to be used in GR4J, 
in a list with entries  \emph{times}, \emph{P} and optionally \emph{PET}.}

\item{systemArgs}{list; contains \code{Param} which is a vector of GR4J 
parameters (obtained from \code{calGR4J}),
\code{dates} which is a vector of dates, 
and \code{PET} which is a optional vector of potential transpiration 
(required if PET not included in \code{data})}

\item{metrics}{a vector of metric names (including 'meanQ' for 
mean daily flow, 'P99' and 'P25' for 99th and 25th percentile daily flows, 
and 'min3yr' for minimum 3-year total flow)}
}
\value{
A vector of metric values
}
\description{
\code{GR4J_wrapper} runs the GR4J model, using the airGR package, for a given 
set of climate inputs and parameter values and produces a set of runoff metrics
}
\examples{
# load dates, precip, PET and streamflow data for Scott Creek
data('data_A5030502')

clim_ref = list(times = data_A5030502$times,P = data_A5030502$P)  

# observed flow
Qobs = data_A5030502$Qobs
# observed PET 
PET = data_A5030502$PET 

dates = as.Date(clim_ref$times)

# calibrate GR4J parameters
Param = calGR4J(dates = dates,P=clim_ref$P,PET=PET,Qobs=Qobs)

# setup systemArgs and metrics
systemArgs = list(dates=dates,Param=Param,PET=PET)
metrics = c('meanQ','P99','P25','min3yr')

metricsObs = GR4J_wrapper(data=clim_ref,systemArgs = systemArgs,metrics=metrics)
metricsObs
}
