% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fracdist.R
\name{fpcrit}
\alias{fpcrit}
\title{Calculate Critical Values for Fractional Unit Root and Cointegration Tests}
\usage{
fpcrit(npts = 9, iq, clevel, probs, bedf, ginv)
}
\arguments{
\item{npts}{An integer number of points for local approximation
of the EDF near the level of significance \code{clevel}.
It is usually 9, unless near a boundary.}

\item{iq}{An integer scalar rank parameter for the test, from 1 through 12.
This is often the difference in cointegration rank.}

\item{clevel}{The numeric scalar level of significance.}

\item{probs}{A numeric vector of probabilities over which an approximating
empirical distribution function is obtained, taken from precalculated tables.}

\item{bedf}{A numeric vector of quantiles of numerical distribution for specified
value of fractional integration order \eqn{b} or values of \eqn{b} and \eqn{d},
depending on the particular model. Each element is the output of the function \code{blocal}.}

\item{ginv}{A numeric vector of quantiles of the approximating chi-squared distribution.}
}
\value{
A numeric scalar critical value, a quantile of the distribution.
}
\description{
\code{fcrit} calculates critical values for a particular level of significance
and a set of intermediate calculations
that are output from other functions in the \code{fracdist} package.
}
\examples{
frtab <- get_fracdist_tab(iq = 3, iscon = 0)
bval <- unique(frtab[, 'bbb'])
probs <- unique(frtab[, 'probs'])
bedf <- rep(NA, length(probs))
for (i in 1:length(probs)) {
    estcrit <- frtab[frtab[, 'probs'] == probs[i], 'xndf']
    bedf[i] <- blocal(nb = 31, bb = 0.75, estcrit, bval)
}
fpcrit(npts = 9, iq = 3, clevel = 0.05, probs, bedf, ginv = qchisq(probs, df = 3^2))
}
\references{
James G. MacKinnon and Morten \enc{Ø}{O}rregaard Nielsen,
"Numerical Distribution Functions of Fractional Unit Root and Cointegration Tests,"
\emph{Journal of Applied Econometrics}, Vol. 29, No. 1, 2014, pp.161-171.
}
\seealso{
fracdist_values for the calculation of critical values and
P-values including any intermediate calculations.
}
