% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.frailtyDesign.R
\name{print.frailtyDesign}
\alias{print.frailtyDesign}
\title{Print a short table of a 'frailtyDesign' result.}
\usage{
\method{print}{frailtyDesign}(x, digits = 2, ...)
}
\arguments{
\item{x}{an object of class 'frailtyDesign' (output from one of the
*.power or *.ssize functions).}

\item{digits}{number of decimals to print for numeric fields. Default is 2.}

\item{\dots}{other unused arguments.}
}
\description{
Print a short table of a 'frailtyDesign' result.
}
\examples{
est.ex <- SFM.power(
  Groups = 400, ni = 3, ni.type = "max", FUP = 6, Acc.Dur = 0.5, median.H0 = 1.5,
  beta.HA = log(0.7), theta = 0.5, cens.par = c(3, 10), cens.type = "Unif", data.type = "rec_event"
)

print(est.ex)

}
\seealso{
\code{\link{frailtyDesign}}
}
\keyword{methods}
