% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.frailtyCmprsk.R
\name{summary.frailtyCmprsk}
\alias{summary.frailtyCmprsk}
\alias{print.summary.frailtyCmprsk}
\title{summary of parameter estimates of a Weibull competing risks model with (or without) shared frailty between transitions.}
\usage{
\method{summary}{frailtyCmprsk}(object, level = 0.95, len = 6, d = 2,
                                 lab="hr",...)
}
\arguments{
\item{object}{output from a call to frailtyCmprsk.}

\item{level}{significance level of confidence interval. Default is 95\%.}

\item{len}{the total field width. Default is 6.}

\item{d}{the desired number of digits after the decimal point. Default of 6
digits is used.}

\item{lab}{label of printed results.}

\item{...}{other unused arguments.}
}
\value{
Prints HR and its confidence intervals. Confidence level is allowed
  (level argument).
}
\description{
This function returns hazard rations (HR) and its confidence intervals
}
\examples{

  \donttest{

    ###--- Simple Weibull competing risks model ---###

    ###--- Weibull competing risks model with shared frailty between transitions ---###

    data(CPRSKbmtcrr)

    ##--- Simple Weibull competing risks model with left truncation ---##

    modCmprskFrailty <- frailtyCmprsk(
      formulas = list(
        Surv(Age, observed_time, Status, type = "mstate") ~ Sex,
        ~ Sex
      ),
      data = CPRSKbmtcrr,
      print.info = FALSE,
      maxit = 100
    )

    #-- Confidence interval at 95\% level (default)

    summary(modCmprskFrailty)

    #-- Confidence interval at 99\% level

    summary(modCmprskFrailty, level = 0.99) }
}
\seealso{
\code{\link{frailtyCmprsk}}
}
\keyword{methods}
