% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSpacePartition.Method.R
\name{FRBCS.CHI}
\alias{FRBCS.CHI}
\title{FRBCS.CHI model building}
\usage{
FRBCS.CHI(range.data, data.train, num.labels, num.class,
  type.mf = "TRIANGLE", type.tnorm = "MIN", type.snorm = "MAX",
  type.implication.func = "ZADEH")
}
\arguments{
\item{range.data}{a matrix (\eqn{2 \times n}) containing the range of the normalized data, where \eqn{n} is the number of variables, and
first and second rows are the minimum and maximum values, respectively.}

\item{data.train}{a matrix (\eqn{m \times n}) of normalized data for the training process, where \eqn{m} is the number of instances and 
\eqn{n} is the number of variables; the last column is the output variable. Note the data must be normalized between 0 and 1.}

\item{num.labels}{a matrix (\eqn{1 \times n}), whose elements represent the number of labels (linguistic terms); 
\eqn{n} is the number of variables.}

\item{num.class}{an integer number representing the number of labels (linguistic terms).}

\item{type.mf}{the type of the shape of the membership functions. See \code{\link{fuzzifier}}.}

\item{type.tnorm}{the type of t-norm. See \code{\link{inference}}.}

\item{type.snorm}{the type of s-norm. See \code{\link{inference}}.}

\item{type.implication.func}{the type of implication function. See \code{\link{WM}}.}
}
\description{
This is the internal function that implements the fuzzy rule-based classification 
system using Chi's technique (FRBCS.CHI). It is used to solve classification tasks. 
Users do not need to call it directly,
but just use \code{\link{frbs.learn}} and \code{\link{predict}}. This method is
suitable only for classification problems.
}
\details{
This method was proposed by Z. Chi, H. Yan, and T. Pham that extends
Wang and Mendel's method for tackling classification problems. 
Basically, the algorithm is quite similar as Wang and Mendel's technique. 
However, since it is based on the FRBCS model, Chi's method only takes class labels on each data
to be consequent parts of fuzzy IF-THEN rules. In other words, we generate rules as in 
Wang and Mendel's technique (\code{\link{WM}}) and then we replace consequent parts with their classes. 
Regarding calculating degress of each rule, they are determined by antecedent parts of the rules. 
Redudant rules can be deleted by considering their degrees. Lastly, we obtain fuzzy IF-THEN rules 
based on the FRBCS model.
}
\references{
Z. Chi, H. Yan, T. Pham, "Fuzzy algorithms with applications to image processing 
and pattern recognition", World Scientific, Singapore (1996).
}
\seealso{
\code{\link{FRBCS.eng}}, \code{\link{frbs.learn}}, and \code{\link{predict}}
}
