% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRBS.pmml.R
\name{write.frbsPMML}
\alias{write.frbsPMML}
\title{The frbsPMML writer}
\usage{
write.frbsPMML(object, fileName = NULL)
}
\arguments{
\item{object}{a frbsPMML object which is an object produced by \code{\link{frbsPMML}}.}

\item{fileName}{a file name with extension \code{.frbsPMML}.}
}
\value{
a file containing an FRBS model in frbsPMML format
}
\description{
It is a function used to save an FRBS model to the .frbsPMML file. Detailed information about frbsPMML can be seen in \code{\link{frbsPMML}}.
}
\examples{
## This example shows how to construct frbsPMML file of frbs model
## Even though we are using MAMDANI model, other models have the same way
## 
## 1. Produce frbs model, for example: we perform Wang & Mendel's technique (WM)
##
## Input data
data(frbsData)
data.train <- frbsData$GasFurnance.dt[1 : 204, ]
data.fit <- data.train[, 1 : 2]
data.tst <- frbsData$GasFurnance.dt[205 : 292, 1 : 2]
real.val <- matrix(frbsData$GasFurnance.dt[205 : 292, 3], ncol = 1)
range.data<-matrix(c(-2.716, 2.834, 45.6, 60.5, 45.6, 60.5), nrow = 2)

## Set the method and its parameters
method.type <- "WM"
control <- list(num.labels = 15, type.mf = "GAUSSIAN", type.defuz = "WAM", 
                type.tnorm = "MIN", type.implication.func = "ZADEH", 
                name = "sim-0") 

## Generate fuzzy model
\dontrun{object <- frbs.learn(data.train, range.data, method.type, control)}

## 2. Write frbsPMML file
## In this step, we provide two steps as follows:
## a. by calling frbsPMML() function directly. 
## b. by calling write.frbsPMML() function. 

## 2a. by calling frbsPMML(), the frbsPMML format will be displayed in R console
\dontrun{pmml.obj <- frbsPMML(object)}

## 2b. by calling write.frbsPMML(), the result will be saved as a file
##     in the working directory.
\dontrun{write.frbsPMML(pmml.obj, file = "MAMDANI.GasFur")}

}
\references{
A. Guazzelli, M. Zeller, W.C. Lin, and G. Williams., 
"pmml: An open standard for sharing models", The R Journal, Vol. 1, No. 1, pp. 60-65 (2009).

Data Mining Group, http://www.dmg.org/.
}
\seealso{
\code{\link{read.frbsPMML}} and \code{\link{frbsPMML}}.
}
