% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fourier.inverse.R
\name{fourier.inverse}
\alias{fourier.inverse}
\title{Coefficients of a discrete Fourier transform}
\usage{
fourier.inverse(F, lags = 0)
}
\arguments{
\item{F}{an object of class \code{\link{freqdom}} which is corresponding to a function with values in \eqn{\mathbf{C}^{d_1\times d_2}}. To guarantee accuracy of inversion it is important that \code{F}\eqn{\$}\code{freq} is a dense grid of frequencies in \eqn{[-\pi,\pi]}.}

\item{lags}{lags of the Fourier coefficients to be computed.}
}
\value{
An object of class \code{\link{timedom}}. The list has the following components:
\itemize{
\item \code{operators} \eqn{\quad} an array. The \eqn{k}-th matrix in this array corresponds to the \eqn{k}-th Fourier coefficient.
\item \code{lags} \eqn{\quad} the lags of the corresponding Fourier coefficients.
}
}
\description{
Computes Fourier coefficients of some functional represented by an object of class \code{freqdom}.
}
\details{
Consider a function \eqn{F \colon [-\pi,\pi]\to\mathbf{C}^{d_1\times d_2}}. Its \eqn{k}-th Fourier
coefficient is given as
\deqn{
  \frac{1}{2\pi}\int_{-\pi}^\pi F(\omega) \exp(ik\omega)d\omega.
}
We represent the function \eqn{F} by an object of class \code{freqdom} and approximate the integral via
\deqn{
\frac{1}{|F\$freq|}\sum_{\omega\in {F\$freq}} F(\omega) \exp(i k\omega),
}
for \eqn{k\in} lags.
}
\examples{
Y = rar(100)
grid = c(pi*(1:2000) / 1000 - pi) #a dense grid on -pi, pi
fourier.inverse(spectral.density(Y, q=2, freq=grid))

# compare this to
cov.structure(Y)
}
\seealso{
\code{\link{fourier.transform}}, \code{\link{freqdom}}
}
\keyword{frequency.domain}
\keyword{time.domain}
