% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{data_filter}
\alias{data_filter}
\title{Filter layer IDs by internal code and department}
\usage{
data_filter(ids = NULL, department, data_code)
}
\arguments{
\item{ids}{\code{data.frame}. Input dataset of IDs. \code{NULL} as default.
If \code{NULL} function uses \code{frheritage::all_ids}.}

\item{department}{\code{character} vector. Department(s) to filter.}

\item{data_code}{\code{character} vector. Data codes to filter. Must be valid heritage layer codes.}
}
\value{
\code{data.frame}. Subset of \code{ids} filtered by \code{data_code} and \code{department}, with \code{departement} column removed.
}
\description{
Filters a dataset of layer IDs based on provided data codes and departments.
}
\details{
\itemize{
\item Uses \code{data_check()} to ensure that all \code{data_code} values are valid.
\item The function currently ignores the \code{ids} argument and always uses \code{frheritage::all_ids}.
}
}
\keyword{internal}
