% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ntimes-friendly.R
\name{ntimes_friendly}
\alias{ntimes_friendly}
\alias{ntimes_friendly_safe}
\title{Translate integer-ish numbers to a character vector of counts (once, twice, three times)}
\usage{
ntimes_friendly(
  numbers,
  one = "once",
  two = "twice",
  three = "three times",
  zero = "no times",
  na = "an unknown number of times",
  nan = "an undefined number of times",
  inf = "infinite times",
  negative = "negative ",
  and = FALSE,
  hyphenate = TRUE
)

ntimes_friendly_safe(
  numbers,
  one = "once",
  two = "twice",
  three = "three times",
  zero = "no times",
  na = "an unknown number of times",
  nan = "an undefined number of times",
  inf = "infinite times",
  negative = "negative ",
  and = FALSE,
  hyphenate = TRUE
)
}
\arguments{
\item{numbers}{\verb{[integer / numeric]}

An integer or integer-ish numeric vector to translate.}

\item{one}{\verb{[character(1)]}

What to call values of \code{1} in \code{numbers} (e.g. \code{one = "the"}).}

\item{two}{\verb{[character(1)]}

What to call values of \code{2} in \code{numbers} (e.g. \code{two = "both"}).}

\item{three}{\verb{[character(1)]}

What to call values of \code{3} in \code{numbers} (e.g. \code{three = "thrice"}).}

\item{zero}{\verb{[character(1)]}

What to call values of \code{0} in \code{numbers} (e.g. \code{zero = "zero"}).}

\item{na}{\verb{[character(1)]}

What to call values of \code{NA} in \code{numbers} (e.g. \code{na = "missing"}).}

\item{nan}{\verb{[character(1)]}

What to call values of \code{NaN} in \code{numbers} (e.g. \code{nan = "undefined"}).}

\item{inf}{\verb{[character(1)]}

What to call values of \code{Inf} in \code{numbers} (e.g. \code{inf = "infinity"}).}

\item{negative}{\verb{[character(1)]}

A prefix added to the translation of negative elements of \code{numbers}.
\code{negative} is the string \code{"negative "} by default.}

\item{and}{\verb{[TRUE / FALSE]}

Whether to insert an \code{" and "} before the tens place of translated \code{numbers}.
\code{and} is \code{FALSE} by default.}

\item{hyphenate}{\verb{[TRUE / FALSE]}

Whether to hyphenate numbers 21 through 99 (e.g. \code{"twenty-one"} vs. \code{"twenty one"}).
\code{hyphenate} is \code{TRUE} by default.}
}
\value{
A non-NA character vector of the same length as \code{numbers}.
}
\description{
Convert an integer vector, or numeric vector which is coercible to an integer
without loss of precision, to a count (e.g. no times, once, twice, four times).

\code{ntimes_friendly_safe()} checks that all arguments are of the correct type
and raises an informative error otherwise. \code{ntimes_friendly()} does not
perform input validation to maximize its speed.
}
\examples{
ntimes_friendly(c(0, 1, 2, 3, 22, 1001, NA, NaN, Inf, -Inf))

# Specify the translations of "special" numbers
ntimes_friendly(c(3, NA), three = "thrice", na = "some times")

# Modify the output formatting
ntimes_friendly(5678)
ntimes_friendly(5678, and = TRUE)
ntimes_friendly(5678, hyphenate = FALSE)

# Input validation
try(ntimes_friendly_safe(1234, and = " - "))
}
