% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Zcurve144bit_RNA.R
\name{Zcurve144bit_RNA}
\alias{Zcurve144bit_RNA}
\title{Z_curve_144bit_RNA (Zcurve144bit_RNA)}
\usage{
Zcurve144bit_RNA(seqs, ORF = FALSE, reverseORF = TRUE, label = c())
}
\arguments{
\item{seqs}{is a FASTA file containing ribonucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a ribonucleotide sequence.}

\item{ORF}{(Open Reading Frame) is a logical parameter. If it is set to true, ORF region of each sequence is considered instead of the original sequence (i.e., 3-frame).}

\item{reverseORF}{is a logical parameter. It is enabled only if ORF is true.
If reverseORF is true, ORF region will be searched in the sequence and also in the reverse complement of the sequence (i.e., 6-frame).}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns is 144.
}
\description{
These group of functions (Zcurve (9, 12, 36, 48, 144)_bit) function calculates the Z-curves. Z-curves are based on freqiencies of ribonucleotides, di-ribonucleotides, or tri-ribonucleotides and their positions on the sequences.
For more information about the methods please refer to reference part.
}
\examples{

fileLNC<-system.file("extdata/Carica_papaya101RNA.txt",package="ftrCOOL")
mat<-Zcurve144bit_RNA(seqs=fileLNC,ORF=TRUE,reverseORF=FALSE)
}
\references{
Gao,F. and Zhang,C.T. Comparison of various algorithms for recognizing short coding sequences of human genes. Bioinformatics, (2004).
}
