% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_Xfgpm_Class.R
\docType{class}
\name{Xfgpm-class}
\alias{Xfgpm-class}
\title{S4 class for funGp model selection data structures}
\description{
This is the formal representation of the assembly of data structures delivered by the model
selection routines in the \link[=funGp-package]{funGp package}. An \code{Xfgpm} object contains the
trace of an optimization process, conducted to build Gaussian process models of outstanding performance.
\itemize{
 \item\strong{Main methods}\cr
       \link[funGp]{fgpm_factory}: structural optimization of \code{fgpm} models,
       creator of the \code{"Xfgpm"} class. \cr
 \item\strong{Plotters}\cr
       \link[funGp]{plot,Xfgpm-method}: plot of the evolution of the algorithm with \code{which = "evolution"}
       or of the absolute and relative quality of the optimized model with \code{which = "diag"}.
}
}
\section{Slots}{

\describe{
\item{\code{factoryCall}}{Object of class \code{"\linkS4class{factoryCall}"}. User call reminder.}

\item{\code{model}}{Object of class \code{"\linkS4class{fgpm}"}. Model selected by the heuristic structural
optimization algorithm.}

\item{\code{stat}}{Object of class \code{"character"}. Performance measure optimized to select the model. To be
set from "Q2loocv", "Q2hout".}

\item{\code{fitness}}{Object of class \code{"numeric"}. Value of the performance measure for the selected model.}

\item{\code{structure}}{Object of class \code{"data.frame"}. Structural configuration of the selected model.}

\item{\code{log.success}}{Object of class \code{"\linkS4class{antsLog}"}. Record of models successfully
evaluated during the structural optimization. It contains the structural configuration both in
data.frame and \code{"\linkS4class{modelCall}"} format, along with the fitness of each model. The
models are sorted by fitness, starting with the best model in the first position.}

\item{\code{log.crashes}}{Object of class \code{"\linkS4class{antsLog}"}. Record of models crashed during the
structural optimization. It contains the structural configuration of each model, both in data.frame
and \code{"\linkS4class{modelCall}"} format.}

\item{\code{n.solspace}}{Object of class \code{"numeric"}. Number of possible structural configurations for
the optimization instance resolved.}

\item{\code{n.explored}}{Object of class \code{"numeric"}. Number of structural configurations successfully
evaluated by the algorithm.}

\item{\code{details}}{Object of class \code{"list"}. Further information about the parameters of the ant colony
optimization algorithm and the evolution of the fitness along the iterations.}

\item{\code{sIn}}{An object of class \code{"matrix"} containing a copy of
the provided scalar inputs.}

\item{\code{fIn}}{An object of class \code{"list"} containing a copy of
the provided functional inputs.}

\item{\code{sOut}}{An object of class \code{"matrix"} containing a copy of the provided outputs.}
}}

\section{Useful material}{

\itemize{
 \item\strong{Manual}
 funGp: An R Package for Gaussian Process Regression with Scalar and Functional Inputs
 (\doi{https://doi.org/10.18637/jss.v109.i05})
}
}

\author{
José Betancourt, François Bachoc, Thierry Klein and Jérémy Rohmer
}
