% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmapc.R
\name{fmapc}
\alias{fmapc}
\title{Apply a function column-wise with name access and parallelism}
\usage{
fmapc(.df, .f, ncores = NULL, pb = FALSE, ...)
}
\arguments{
\item{.df}{A data frame whose columns will be iterated over.}

\item{.f}{A function that takes two arguments: the column vector and its name.}

\item{ncores}{Integer. Number of cores to use for parallel processing. Default is `NULL` (sequential).}

\item{pb}{Logical. Whether to display a progress bar. Default is `FALSE`.}

\item{...}{Additional arguments passed to `.f`.}
}
\value{
A list of results obtained by applying `.f` to each column of `.df`.
}
\description{
Applies a function `.f` to each column of a data frame `.df`. Each call receives both
the column vector and its name, enabling name-aware column processing. Supports parallel execution and progress display.
}
\examples{
df <- data.frame(a = 1:3, b = 4:6)

# Apply a function that returns column mean and name
fmapc(df, function(x, name) list(mean = mean(x), var = var(x), name = name))

# With progress and parallel execution
\donttest{
fmapc(df, function(x, name) mean(x), ncores = 2, pb = TRUE)
}

}
