% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{speciesdata}
\alias{speciesdata}
\title{Efiplus data used to develop ecological sensitivity parameters for riverine species in European streams and rivers.}
\format{
A \code{tibble} 99 rows and 23 columns.

\itemize{
\item scientificName: The fish species names extracted from the EFIPLUS dataset.
\item waterBody: The water body from which the species records were collected.
\item decimalLatitude: Species location
\item decimalLongitude: Species occurrence records.
\item MRR: The locality where the species was collated or sampled from
\item Date: the day, month, and year when the species record was collected.
\item: year: The year when the species record was collated.
\item Locality: particular locality where the species was sampled.
\item country: The country where the record was made.

}
}
\usage{
data(speciesdata)
}
\description{
A \code{tibble}
}
\details{
BQEs sensitivity to global/climate change in European rivers:
implications for reference conditions and pressure-impact-recovery chains (Logez et al. 2012). An extract has been made for
usage in this package but for more information write to ihg@boku.ac.at
}
\examples{

\dontrun{

data("speciesdata")
speciesdata
}


}
\references{
Logez M, Belliard J, Melcher A, Kremser H, Pletterbauer F, Schmutz S, Gorges G, Delaigue O, Pont D. 2012.
Deliverable D5.1-3: BQEs sensitivity to global/climate change in European rivers: implications for reference conditions
and pressure-impact-recovery chains.
}
\keyword{European}
\keyword{dataset}
\keyword{wide}
