% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gevExpInfo.R
\name{gevExpInfo}
\alias{gevExpInfo}
\alias{gev11e}
\alias{gev22e}
\alias{gev33e}
\alias{gev12e}
\alias{gev13e}
\alias{gev23e}
\title{GEV Distribution Expected Information}
\usage{
gev11e(scale, shape)

gev22e(scale, shape, eps = 0.003)

gev33e(shape, eps = 0.003)

gev12e(scale, shape, eps = 0.003)

gev13e(scale, shape, eps = 0.003)

gev23e(scale, shape, eps = 0.003)

gevExpInfo(scale, shape, eps = 0.003)
}
\arguments{
\item{scale, shape}{Numeric vectors. Respective values of the GEV parameters
scale parameter \eqn{\sigma} and shape parameter \eqn{\xi}. For
\code{gevExpInfo}, \code{scale} and \code{shape} must have length 1.}

\item{eps}{A numeric scalar. For values of \eqn{\xi} in \code{shape} that lie in
\verb{(-eps, eps)} an approximation is used instead of a direct calculation.
See \strong{Details}. If \code{eps} is a vector then only the first element is used.}
}
\value{
\code{gevExpInfo} returns a 3 by 3 numeric matrix with row and column
named \verb{loc, scale, shape}. The other functions return a numeric vector of
length equal to the maximum of the lengths of the arguments, excluding
\code{eps}.
}
\description{
Calculates the expected information matrix for the GEV distribution.
}
\details{
\code{gevExpInfo} calculates, for a single pair of values
\eqn{(\sigma, \xi) = } \verb{(scale, shape)}, the expected information matrix for a
single observation from a GEV distribution with distribution function
\deqn{F(x) = P(X \leq x) = \exp\left\{ -\left[ 1+\xi\left(\frac{x-\mu}{\sigma}\right)
  \right]_+^{-1/\xi} \right\},}
where \eqn{x_+ = \max(x, 0)}.
The GEV expected information is defined only for \eqn{\xi > -0.5} and does
not depend on the value of \eqn{\mu}.

The other functions are vectorized and calculate the individual
contributions to the expected information matrix. For example, \code{gev11e}
calculates the expectation \eqn{i_{\mu\mu}} of the negated second
derivative of the GEV log-density with respect to \eqn{\mu}, that is, each
\code{1} indicates one derivative with respect to \eqn{\mu}. Similarly, \code{2}
denotes one derivative with respect to \eqn{\sigma} and \code{3} one derivative
with respect to \eqn{\xi}, so that, for example, \code{gev23e} calculates the
expectation \eqn{i_{\sigma\xi}} of the negated GEV log-density after one
taking one derivative with respect to \eqn{\sigma} and one derivative with
respect to \eqn{\xi}. Note that \eqn{i_{\xi\xi}}, calculated using
\code{gev33e}, depends only on \eqn{\xi}.

The expectation in \code{gev11e} can be calculated in a direct way for all
\eqn{\xi > -0.5}. For the other components, direct calculation of the
expectation is unstable when \eqn{\xi} is close to 0. Instead, we use
a quadratic approximation over \verb{(-eps, eps)}, from a Lagrangian
interpolation of the values from the direct calculation for \eqn{\xi = }
\code{-eps}, \eqn{0} and \code{eps}.
}
\examples{
# Expected information matrices for ...
# ... scale = 2 and shape = -0.4
gevExpInfo(2, -0.4)
# ... scale = 3 and shape = 0.001
gevExpInfo(3, 0.001)
# ... scale = 3 and shape = 0
gevExpInfo(3, 0)
# ... scale = 1 and shape = 0.1
gevExpInfo(1, 0.1)

# The individual components of the latter matrix
gev11e(1, 0.1)
gev12e(1, 0.1)
gev13e(1, 0.1)
gev22e(1, 0.1)
gev23e(1, 0.1)
gev33e(0.1)
}
