% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammaFuncModel.R
\name{pk_calculation}
\alias{pk_calculation}
\title{Function that returns a data frame for Tmax, Cmax, half-life, AUC and AUCInf for metabolites}
\usage{
pk_calculation(df, met_vec, models, grp_name = "Diet", covariates, ref = 1)
}
\arguments{
\item{df}{Data frame containing columns Group(factor); ID(subject ID: character); Time(positive: numeric); other individiual characteristics covariates (exlcluding other forms of 'Time')
Note: Data must be complete (No missing values).}

\item{met_vec}{Vector of metabolite names}

\item{models}{Fitted models for all metabolites of interest}

\item{grp_name}{Name of the grouping variable}

\item{covariates}{Vector containing the names of the "ID" covariate, grouping covariate and other covariates excluding any "Time" covariates}

\item{ref}{reference level for the grouping variable. could be numeric or character}
}
\value{
Data frame with the pharmacokinetic properties of each metabolite
}
\description{
Function that returns a data frame for Tmax, Cmax, half-life, AUC and AUCInf for metabolites
}
\examples{
require(gammaFuncModel)
require(dplyr)
\donttest{
df <- data.frame(
 ID = rep(sprintf("\%02d", 1:10), each = 9 * 3),             
 Time = rep(rep(1:9, each = 3), 10),                      
 Diet = as.factor(rep(1:3, times = 9 * 10)),             
 Age = rep(sample(20:70, 10, replace = TRUE), each = 9 * 3), 
 BMI = round(rep(runif(10, 18.5, 35), each = 9 * 3), 1)     
)
metvar <- paste0("met", 1:10)
n_rows <- nrow(df)
concentration_data <- sapply(1:10, function(m) {
 shape <- runif(1, 2, 5)     
 scale <- runif(1, 1, 3)     
 rgamma(n_rows, shape = shape, scale = scale)
})
colnames(concentration_data) <- metvar
df <- cbind(df, as.data.frame(concentration_data))
covariates <- c("ID", "Diet", "Age", "BMI")
mods <- generate_models(df = df, met_vec = metvar, covariates = covariates, graph = 'None')
result <- pk_calculation(
  df = df, 
  met_vec = metvar, 
  models = mods, 
  grp_name = "Diet", 
  covariates = covariates
 )
}
}
\references{
Wickham, H. (2022). dplyr: A Grammar of Data Manipulation. R package version 1.0.10. 
Available at: \url{https://CRAN.R-project.org/package=dplyr}

Pinheiro, J. C., & Bates, D. M. (2022). nlme: Linear and Nonlinear Mixed Effects Models. R package version 3.1-153.
Available at: \url{https://CRAN.R-project.org/package=nlme}
}
