% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapmap-package.R
\docType{package}
\name{gapmap-package}
\alias{gapmap-package}
\title{Draws gapped heatmap (gapmap) and gapped dendrograms using ggplot2 in [R].}
\description{
Functions for drawing gapped cluster heatmap with ggplot2
}
\details{
This is a set of tools for drawing gapmaps using \code{\link[ggplot2]{ggplot}}

\code{\link{gap_data}} extracts data from a dendrogram object. Make sure to convert \code{hclust} object to \code{dendrogram} object by calling \code{as.dendrogram()}.
This method generates an object class \code{gapdata}, consisting of a list of \code{data.frames}.
The general workflow is as following:
\enumerate{
\item{Hierarchical clustering \code{hclust()}}
\item{Convert the \code{hclust} output class into \code{dendrogram} by calling \code{as.dendrogram()}}
\item{Generate a gapped cluster heatmap by specifying a \code{matrix} and \code{dendrogram} objects for rows and columns in \code{gapmap()} function}
}
}
\author{
Ryo Sakai \email{ryo.sakai@esat.kuleuven.be}
}
\keyword{package}
