% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_columns.R
\name{fix_columns}
\alias{fix_columns}
\title{Used in gators_download() - Fill out taxonomic name columns}
\usage{
fix_columns(
  df,
  scientific.name = "scientificName",
  genus = "genus",
  species = "specificEpithet",
  infraspecific.epithet = "infraspecificEpithet"
)
}
\arguments{
\item{df}{Data frame of occurrence records.}

\item{scientific.name}{Default = "scientificName". The name of the \href{http://rs.tdwg.org/dwc/terms/scientificName}{scientificName} column in the data frame.}

\item{genus}{Default = "genus". The name of the \href{http://rs.tdwg.org/dwc/terms/genus}{genus} column in the data frame.}

\item{species}{Default = "specificEpithet". The name of the \href{http://rs.tdwg.org/dwc/terms/specificEpithet}{specificEpithet} column in the data frame.}

\item{infraspecific.epithet}{Default = "infraspecificEpithet". The name of the \href{http://rs.tdwg.org/dwc/terms/infraspecificEpithet}{infraspecificEpithet} column in the data frame.}
}
\value{
Returns the original data frame with the specified columns.
}
\description{
The \code{fix_columns()} function fills out the taxonomic name columns based on available information in the data set.
For example, if a row has a name provided for the scientificName column, this information will be used
to generate the respective genus, specificEpithet, and infraspecificEpithet columns for that row.
}
\details{
This function requires package stringr.
}
\examples{
fixed_data <- fix_columns(data)

}
