% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_missing.R
\name{remove_missing}
\alias{remove_missing}
\title{Remove Missing Information - Prepare to merge a data frame with georeferenced and retrieved records}
\usage{
remove_missing(
  df,
  remove.type = "both",
  info.withheld = "informationWithheld",
  longitude = "longitude",
  latitude = "latitude",
  locality = "locality",
  id = "ID"
)
}
\arguments{
\item{df}{A data frame downloaded with \code{gators_download()}.}

\item{remove.type}{Default equal to "both" indicating records identified with the \code{need_to_georeference()} function
and \code{needed_records()} function are removed from the data frame. If equal to "georeference" then only records
identified by the \code{need_to_georeference()} function are removed. If equal to "withheld" then only records identified
with the \code{needed_records()} function are removed.}

\item{info.withheld}{Default = "informationWithheld". The name of the \href{http://rs.tdwg.org/dwc/iri/informationWithheld}{information withheld} column in the data frame.}

\item{longitude}{Default = "longitude". The name of the \href{http://rs.tdwg.org/dwc/terms/decimalLongitude}{longitude} column in the data frame.}

\item{latitude}{Default = "latitude". The name of the \href{http://rs.tdwg.org/dwc/terms/decimalLatitude}{latitude} column in the data frame.}

\item{locality}{Default = "locality". The name of the \href{http://rs.tdwg.org/dwc/terms/locality}{locality} column in the data frame.}

\item{id}{Default = "ID". The name of the id column in the data frame, which contains unique IDs defined from GBIF (keys) or iDigBio (UUID).}
}
\value{
A data frame with records containing missing information removed.
Information about the columns in the returned data frame can be found in the documentation for \code{gators_download()}.
}
\description{
The \code{remove_missing()} function identifies and removes records identified with the \code{need_to_georeference()}
and \code{needed_records()} functions. This function should be utilized prior to merging georeferenced or retrieved records.
}
\details{
This function requires no additional packages.
}
\examples{
cleaned_data <- remove_missing(data)

}
