% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbeta.R
\name{GBeta}
\alias{GBeta}
\alias{dgbeta}
\alias{pgbeta}
\alias{rgbeta}
\alias{qgbeta}
\title{Generalized Beta distribution}
\usage{
dgbeta(u, c, d, kappa, tau, log = FALSE)

pgbeta(q, c, d, kappa, tau)

rgbeta(n, c, d, kappa, tau, method = "mixture")

qgbeta(p, c, d, kappa, tau)
}
\arguments{
\item{u}{numeric vector}

\item{c, d, kappa, tau}{parameters; they must be strictly positive numbers, 
except \code{kappa} which can take any value}

\item{log}{logical, whether to return the log-density}

\item{q}{numeric vector of quantiles}

\item{n}{positive integer, the desired number of simulations}

\item{method}{the method of random generation, \code{"mixture"} or 
\code{"arou"}; only a positive \code{kappa} is allowed for the 
\code{"mixture"} method, but this method is faster}

\item{p}{numeric vector of probabilities}
}
\description{
Density, distribution function, quantile function, and random 
  generation for the generalized Beta distribution.
}
\examples{
library(gbeta)
curve(dgbeta(x, 4, 12, 10, 0.01), axes = FALSE, lwd = 2)
axis(1)

}
\references{
\itemize{
  \item Marwa Hamza & Pierre Vallois. 
    \emph{On Kummer’s distributions of type two and generalized Beta 
          distributions}.
    Statistics & Probability Letters 118 (2016), pp. 60-69.
    <doi:10.1016/j.spl.2016.03.014>
  \item James J. Chen & Melvin R. Novick.
    \emph{Bayesian Analysis for Binomial Models with Generalized Beta Prior 
          Distributions}.
    Journal of Educational Statistics 9, No. 2 (1984), pp. 163-175.
    <doi:10.3102/10769986009002163>
}
}
