% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gclm.R
\name{gclm.lowertri}
\alias{gclm.lowertri}
\title{Recover lower triangular GCLM}
\usage{
gclm.lowertri(Sigma, P = solve(Sigma), C = diag(nrow = nrow(Sigma)))
}
\arguments{
\item{Sigma}{covariance matrix}

\item{P}{the inverse of the  covariance matrix}

\item{C}{symmetric positive definite matrix}
}
\value{
A stable lower triangular matrix
}
\description{
Recover the only lower triangular stable matrix B such that
\code{Sigma} (\eqn{\Sigma})
is the solution of the associated continuous Lyapunov equation:
\deqn{B\Sigma + \Sigma B' + C = 0}
}
