% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gclm.R
\name{clyap}
\alias{clyap}
\title{Solve continuous-time Lyapunov equations}
\usage{
clyap(B, C, Q = NULL, all = FALSE)
}
\arguments{
\item{B}{Square matrix}

\item{C}{Square matrix}

\item{Q}{Square matrix, the orthogonal matrix used
to transform the original equation}

\item{all}{logical}
}
\value{
The solution matrix \code{X} if \code{all = FALSE}. If
\code{all = TRUE} a list with components \code{X}, \code{B}
and \code{Q}. Where \code{B} and \code{Q} are the
Hessenberg-Schur form of the original matrix \code{B}
and the orthogonal matrix that performed the transformation.
}
\description{
\code{clyap} solve the continuous-time Lyapunov equations
\deqn{BX + XB' + C=0}
Using the Bartels-Stewart algorithm with Hessenberg–Schur
decomposition. Optionally the Hessenberg-Schur
decomposition can be returned.
}
\details{
If the matrix \code{Q} is set then the matrix \code{B}
is assumed to be in upper quasi-triangular form
(Hessenberg-Schur canonical form),
as required by LAPACK subroutine \code{DTRSYL} and \code{Q} is
the orthogonal matrix associated with the Hessenberg-Schur form
of \code{B}.
Usually the matrix \code{Q} and the appropriate form of \code{B}
are obtained by a first call to \code{clyap(B, C, all = TRUE)}

\code{clyap} uses lapack subroutines:
\itemize{
\item \code{DGEES}
\item \code{DTRSYL}
\item \code{DGEMM}
}
}
\examples{
B <- matrix(data = rnorm(9), nrow = 3)
## make B negative diagonally dominant, thus stable:
diag(B) <- - 3 * max(B) 
C <- diag(runif(3))
X <- clyap(B, C)
## check X is a solution:
max(abs(B \%*\% X + X \%*\% t(B) + C)) 
}
