% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.gctsc}
\alias{residuals.gctsc}
\title{Compute Randomized Quantile Residuals for Gaussian Copula Time Series}
\usage{
\method{residuals}{gctsc}(object, method = NULL, ...)
}
\arguments{
\item{object}{A fitted object of class \code{gctsc}, produced by \code{\link{gctsc}}.}

\item{method}{Can be \code{TMET} or \code{GHK}}

\item{...}{Ignored. Included for S3 method compatibility.}
}
\value{
A list containing:
\item{residuals}{A numeric vector of randomized quantile residuals.}
\item{pit}{A numeric vector of PIT values.}
}
\description{
Computes residuals for a fitted \code{gctsc} object using randomized quantile residuals.
}
\examples{
y <- sim_poisson(mu = 5, tau = 0.7, arma_order = c(1, 0), nsim = 100)
fit <- gctsc(y ~ 1, marginal = poisson.marg(), cormat = arma.cormat(1, 0),
             method = "GHK", options = gctsc.opts(seed = 1, M = 1000))
res <- residuals(fit)
hist(res$residuals, main = "Randomized Quantile Residuals", xlab = "Residual")
hist(res$pit, main = "PIT Histogram", xlab = "PIT values")

}
\references{
Dunn, P. K. and Smyth, G. K. (1996), Randomized quantile residuals,
\emph{Journal of Computational and Graphical Statistics}, \strong{5}(3): 236-244.
}
