% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdi.r
\name{transfer_ratio}
\alias{transfer_ratio}
\title{Transfer a vector of aspect ratios onto another body profile}
\usage{
transfer_ratio(
  lat = NULL,
  dors = NULL,
  indices = NULL,
  lat0,
  dors0,
  indices0 = NULL,
  smooth = 0.005,
  return = "diameters",
  ...
)
}
\arguments{
\item{lat}{diameters in lateral view, supply to estimate transverse diameters from dorsoventral ones}

\item{dors}{diameters in dorsal (or ventral) view, supply to estimate dorsoventral diameters from transverse ones}

\item{indices}{optional vector of indices to apply to subset lat or dors}

\item{lat0}{(dorsoventral) diameters in lateral view for template}

\item{dors0}{(transverse) diameters in dorsal/ventral view for template (vector is subsetted to same length as lat0 if lengths don’t match)}

\item{indices0}{optional vector of indices to subset lat0 and dors0}

\item{smooth}{width of smoothing interval (as fraction of full silhouette length)}

\item{return}{what to return, either "diameters" to return diameters, or "ratios", to return ratios}

\item{...}{additional arguments to pass on to paleoDiv::rmeana() for computation of running mean of diameter ratios}
}
\value{
Either a numeric vector of interpolated transverse or dorsoventral diameters or width/depth or depth/width ratios depending on the chosen settings, or a data.frame of same format as dors0 or lat0 (with the "center" column copied)
}
\description{
Transfer a vector of aspect ratios onto another body profile
}
\examples{
fdir <- system.file(package="gdi")
lat <- measuresil(file.path(fdir,"exdata","lat.png"), return="all")
dors <- measuresil(file.path(fdir,"exdata","dors.png"), return="all")
gdi(lat,dors,scale=100) #real volume
dors_est <- transfer_ratio(lat=lat,lat0=lat,dors0=dors,smooth=0.005)
gdi(lat,dors_est,scale=100) #volume with dorsal view interpolated
lat_est <- transfer_ratio(dors=dors,lat0=lat,dors0=dors,smooth=0.005)
gdi(lat_est,dors,scale=100) #volume with lateral view interpolated
plot_sil(lat,asp=1) #visualize results
plot_sil(dors,add=TRUE)
plot_sil(lat_est,add=TRUE,col="blue",alpha=0.3)
plot_sil(dors_est,add=TRUE,col="blue",alpha=0.3)
}
