% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gelnet.R
\name{gelnet}
\alias{gelnet}
\title{GELnet for linear regression, binary classification and one-class problems.}
\usage{
gelnet(X, y, l1, l2, nFeats = NULL, a = rep(1, n), d = rep(1, p),
  P = diag(p), m = rep(0, p), max.iter = 100, eps = 1e-05,
  w.init = rep(0, p), b.init = NULL, fix.bias = FALSE, silent = FALSE,
  balanced = FALSE, nonneg = FALSE)
}
\arguments{
\item{X}{n-by-p matrix of n samples in p dimensions}

\item{y}{n-by-1 vector of response values. Must be numeric vector for regression, factor with 2 levels for binary classification, or NULL for a one-class task.}

\item{l1}{coefficient for the L1-norm penalty}

\item{l2}{coefficient for the L2-norm penalty}

\item{nFeats}{alternative parameterization that returns the desired number of non-zero weights. Takes precedence over l1 if not NULL (default: NULL)}

\item{a}{n-by-1 vector of sample weights (regression only)}

\item{d}{p-by-1 vector of feature weights}

\item{P}{p-by-p feature association penalty matrix}

\item{m}{p-by-1 vector of translation coefficients}

\item{max.iter}{maximum number of iterations}

\item{eps}{convergence precision}

\item{w.init}{initial parameter estimate for the weights}

\item{b.init}{initial parameter estimate for the bias term}

\item{fix.bias}{set to TRUE to prevent the bias term from being updated (regression only) (default: FALSE)}

\item{silent}{set to TRUE to suppress run-time output to stdout (default: FALSE)}

\item{balanced}{boolean specifying whether the balanced model is being trained (binary classification only) (default: FALSE)}

\item{nonneg}{set to TRUE to enforce non-negativity constraints on the weights (default: FALSE )}
}
\value{
A list with two elements:
\describe{
  \item{w}{p-by-1 vector of p model weights}
  \item{b}{scalar, bias term for the linear model (omitted for one-class models)}
}
}
\description{
Infers the problem type and learns the appropriate GELnet model via coordinate descent.
}
\details{
The method determines the problem type from the labels argument y.
If y is a numeric vector, then a regression model is trained by optimizing the following objective function:
\deqn{ \frac{1}{2n} \sum_i a_i (y_i - (w^T x_i + b))^2 + R(w) }

If y is a factor with two levels, then the function returns a binary classification model, obtained by optimizing the following objective function:
\deqn{ -\frac{1}{n} \sum_i y_i s_i - \log( 1 + \exp(s_i) ) + R(w) }
 where
\deqn{ s_i = w^T x_i + b }

Finally, if no labels are provided (y == NULL), then a one-class model is constructed using the following objective function:
\deqn{ -\frac{1}{n} \sum_i s_i - \log( 1 + \exp(s_i) ) + R(w) }
 where
\deqn{ s_i = w^T x_i }

In all cases, the regularizer is defined by
\deqn{ R(w) = \lambda_1 \sum_j d_j |w_j| + \frac{\lambda_2}{2} (w-m)^T P (w-m) }

The training itself is performed through cyclical coordinate descent, and the optimization is terminated after the desired tolerance is achieved or after a maximum number of iterations.
}
\seealso{
\code{\link{gelnet.lin.obj}}, \code{\link{gelnet.logreg.obj}}, \code{\link{gelnet.oneclass.obj}}
}

