% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{genaDiff}
\alias{genaDiff}
\alias{gena.grad}
\alias{gena.hessian}
\title{Numeric Differentiation}
\usage{
gena.grad(
  fn,
  par,
  eps = sqrt(.Machine$double.eps) * abs(par),
  method = "central-difference",
  fn.args = NULL
)

gena.hessian(
  fn = NULL,
  gr = NULL,
  par,
  eps = sqrt(.Machine$double.eps) * abs(par),
  fn.args = NULL,
  gr.args = NULL
)
}
\arguments{
\item{fn}{function for which gradient or Hessian should be calculated.}

\item{par}{point (parameters' value) at which \code{fn} should be 
differentiated.}

\item{eps}{numeric vector representing increment of the \code{par}. 
So \code{eps[i]} represents increment of \code{par[i]}. If \code{eps} is
a constant then all increments are the same.}

\item{method}{numeric differentiation method: "central-difference" or
"forward-difference".}

\item{fn.args}{list containing arguments of \code{fn} except \code{par}.}

\item{gr}{gradient function of \code{fn}.}

\item{gr.args}{list containing arguments of \code{gr} except \code{par}.}
}
\value{
Function \code{gena.grad} returns a vector that is a gradient of 
\code{fn} at point \code{par} calculated via \code{method} numeric 
differentiation approach using increment \code{eps}.

Function \code{gena.hessian} returns a matrix that is a Hessian of 
\code{fn} at point \code{par}.
}
\description{
Numeric estimation of the gradient and Hessian.
}
\details{
It is possible to substantially improve numeric Hessian accuracy 
by using analytical gradient \code{gr}. If both \code{fn} and \code{gr}
are provided then only \code{gr} will be used. If only \code{fn} is provided 
for \code{gena.hessian} then \code{eps} will be transformed to 
\code{sqrt(eps)} for numeric stability purposes.
}
\examples{
# Consider the following function
fn <- function(par, a = 1, b = 2)
{
  val <- par[1] * par[2] - a * par[1] ^ 2 - b * par[2] ^ 2
}

# Calculate the gradient at point (2, 5) respect to 'par' 
# when 'a = 1' and 'b = 1'
par <- c(2, 5)
fn.args = list(a = 1, b = 1)
gena.grad(fn = fn, par = par, fn.args = fn.args)

# Calculate Hessian at the same point
gena.hessian(fn = fn, par = par, fn.args = fn.args)

# Repeat calculation of the Hessian using analytical gradient
gr <- function(par, a = 1, b = 2)
{
  val <- c(par[2] - 2 * a * par[1],
           par[1] - 2 * b * par[2])
}
gena.hessian(gr = gr, par = par, gr.args = fn.args)

}
