library(testthat)

test_that("rss.simulation works as expected",{
  set.seed(123)
  result <- rss.simulation(H=3, nsamp=c(3,5,7), dist="normal", rho=0.8, delta=0)
  expect_s3_class(result,"data.frame")
  expect_equal(colnames(result), c("rank","y"))
  expect_equal(dim(result), c(15,2))
  result.lth <- as.numeric(tapply(result$y,result$rank,length))
  expect_equal(result.lth, c(3,5,7))
  result.mu=mean(tapply(result$y, result$rank, mean))
  expect_equal(round(result.mu,5), c(0.00517))

  set.seed(123)
  result <- rss.simulation(H=4, nsamp=c(6,6,5,4), dist="t", rho=0.9, delta=1)
  expect_s3_class(result,"data.frame")
  expect_equal(colnames(result), c("rank","y"))
  expect_equal(dim(result), c(21,2))
  result.lth <- as.numeric(tapply(result$y,result$rank,length))
  expect_equal(result.lth, c(6,6,5,4))
  result.mu=mean(tapply(result$y, result$rank, mean))
  expect_equal(round(result.mu,5), c(1.01466))

  set.seed(123)
  result <- rss.simulation(H=5, nsamp=c(6,6,6,5,4), dist="lognorm", rho=1, delta=0)
  expect_s3_class(result,"data.frame")
  expect_equal(colnames(result), c("rank","y"))
  expect_equal(dim(result), c(27,2))
  result.lth <- as.numeric(tapply(result$y,result$rank,length))
  expect_equal(result.lth, c(6,6,6,5,4))
  result.mu=mean(tapply(result$y, result$rank, mean))
  expect_equal(round(result.mu,5), c(0.20226))
})

test_that("rss.simulation handles wrong input with error",{
  expect_error(rss.simulation(H=3, nsamp=c(3,5,7,8), dist="normal", rho=0.8, delta=0),
               "Set size are different with the length of sample allocations")
  expect_error(rss.simulation(H=2, nsamp=c(3,5,7), dist="normal", rho=0.8, delta=0),
               "Set size are different with the length of sample allocations")
  expect_error(rss.simulation(H=3, nsamp=c(3,5,7), dist="normal", rho=1.2, delta=0),
               "Invalid value for rho.")
  expect_error(rss.simulation(H=3, nsamp=c(3,5,7), dist="unif", rho=1, delta=0),
               "Invalid distribution selected.")
})
