% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_mle_function.R
\name{linear.mles}
\alias{linear.mles}
\title{Function to calculate MLE's for linear models}
\usage{
linear.mles(m, es_ab, es_bb, model)
}
\arguments{
\item{m}{minor allele frequency}

\item{es_ab}{effect size for mean AB - mean AA}

\item{es_bb}{effect size for mean BB - mean AA}

\item{model}{The assumed genetic model(s) used in testing: 'Dominant', 'Additive', 'Recessive', '2df'}
}
\value{
A vector of linear regression model coefficients.
}
\description{
Finds the maximum likelihood estimates for a given MAF under the specified genetic model and effect size.
}
\examples{
linear.mles(m = 0.1, es_ab = 0, es_bb = 3, model = "Dominant")

}
