% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/georefar.R
\name{get_asentamientos}
\alias{get_asentamientos}
\title{Obtener Asentamientos de BAHRA}
\usage{
get_asentamientos(
  id = NULL,
  nombre = NULL,
  provincia = NULL,
  departamento = NULL,
  municipio = NULL,
  localidad_censal = NULL,
  orden = NULL,
  aplanar = TRUE,
  campos = NULL,
  max = NULL,
  exacto = NULL
)
}
\arguments{
\item{id}{text Filtrar por ID.}

\item{nombre}{text Filtrar por Nombre.}

\item{provincia}{text Filtrar por nombre o ID de Provincia.}

\item{departamento}{text Filtrar por nombre o ID de Departamento.}

\item{municipio}{text Filtrar por nombre o ID de Municipio.}

\item{localidad_censal}{text Filtrar por nombre o ID de localidad censal. Se pueden especificar varios IDs separados por comas}

\item{orden}{text Campo por el cual ordenar los resultados (por ID o nombre)}

\item{aplanar}{boolean Cuando está presente, muestra el resultado JSON con una estructura plana.}

\item{campos}{text Campos a incluir en la respuesta separados por comas, sin espacios. Algunos campos siempre serán incluidos, incluso si no se agregaron en la lista. Para incluir campos de sub-entidades, separar los nombres con un punto, por ejemplo: provincia.id.}

\item{max}{integer Cantidad máxima de resultados a devolver.}

\item{exacto}{boolean Cuando está presente, se activa el modo de búsqueda por texto exacto. Sólo tiene efecto cuando se usan campos de búsqueda por texto (por ejemplo, nombre).}
}
\value{
Un Data Frame con el listado de Asentamientos BAHRA.
}
\description{
Permite realizar búsquedas sobre el listado de asentamientos BAHRA.
Realiza la consulta GET al endpoint /asentamientos de georef-ar-api.
Si existe GEOREFAR_TOKEN en el Renviron lo usará para hacer la consulta.
}
\examples{
\dontrun{
get_asentamientos()
}
}
\references{
\href{https://datosgobar.github.io/georef-ar-api/open-api/#/Recursos/get_asentamientos}{georef-ar-api/asentamientos}
}
