% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_indices.R
\name{calc_raster_spinconsistency}
\alias{calc_raster_spinconsistency}
\title{calculate spatial inconsistency for raster}
\usage{
calc_raster_spinconsistency(
  matrices,
  window,
  adj = FALSE,
  dataset = NULL,
  mindist = 1e-11
)
}
\arguments{
\item{matrices}{A list of matrices}

\item{window}{The window to use to define spatial neighbouring}

\item{adj}{A boolean indicating if the adjusted version of the algorithm must be
calculated}

\item{dataset}{A list of matrices with the original data (if adj = TRUE)}

\item{mindist}{When adj is true, a minimum value for distance between two observations. If two
neighbours have exactly the same values, then the euclidean distance between
them is 0, leading to an infinite spatial weight. In that case, the minimum
distance is used instead of 0.}
}
\value{
A float: the sum of spatial inconsistency
}
\description{
Calculate the spatial inconsistency sum for a set of rasters
}
\examples{
# this is an internal function, no example provided
}
\keyword{internal}
