% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodimension.R
\name{add_level}
\alias{add_level}
\alias{add_level.geodimension}
\title{Add a level to a dimension}
\usage{
add_level(gd, level)

\method{add_level}{geodimension}(gd, level = NULL)
}
\arguments{
\item{gd}{A \code{geodimension} object.}

\item{level}{A \code{geolevel}, level to add to the dimension.}
}
\value{
A \code{geodimension}.
}
\description{
Once a level is part of the dimension, it can then be related to other levels
of the dimension.
}
\examples{

layer_us_place <- gd_us |>
  get_level_layer("place")

layer_us_county <-
  dplyr::inner_join(
    get_level_data_geo(gd_us, "county"),
    get_level_layer(gd_us, "county"),
    by = c("geoid", "statefp", "name", "type")
  ) |>
  sf::st_as_sf()

place <-
  geolevel(name = "place",
           layer = layer_us_place,
           attributes = c("statefp", "county_geoid", "name", "type"),
           key = "geoid")

county <-
  geolevel(
    name = "county",
    layer = layer_us_county,
    attributes = c("statefp", "name", "type"),
    key = "geoid"
  ) |>
  add_geometry(coordinates_to_geometry(layer_us_county,
                                       lon_lat = c("intptlon", "intptlat")))

gd_us <-
  geodimension(name = "gd_us",
               level = place) |>
  add_level(level = county)

}
\seealso{
\code{\link{geolevel}}, \code{\link{relate_levels}}, \code{\link{get_level_layer}}

Other geodimension definition functions: 
\code{\link{geodimension}()},
\code{\link{set_level_data}()},
\code{\link{transform_crs}()}
}
\concept{geodimension definition functions}
